implementation module StdPictureDef


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdPictureDef contains the predefined figures that can be drawn.
//	********************************************************************************


import	StdIOBasic


::	Box										// A box is a rectangle
	=	{	box_w			:: !Int			// The width  of the box
		,	box_h			:: !Int			// The height of the box
		}
::	Oval									// An oval is a stretched unit circle
	=	{	oval_rx			:: !Int			// The horizontal radius (stretch)
		,	oval_ry			:: !Int			// The vertical   radius (stretch)
		}
::	Curve									// A curve is a slice of an oval
	=	{	curve_oval		:: !Oval		// The source oval
		,	curve_from		:: !Real		// Starting angle (in radians)
		,	curve_to		:: !Real		// Ending   angle (in radians)
		,	curve_clockwise	:: !Bool		// Direction: True iff clockwise
		}
::	Polygon									// A polygon is an outline shape
	=	{	polygon_shape	:: ![Vector]	// The shape of the polygon
		}
::	FontDef
	=	{	fName			:: !FontName	// Name of the font
		,	fStyles			:: ![FontStyle]	// Stylistic variations
		,	fSize			:: !FontSize	// Size in points
		}
::	FontMetrics
	=	{	fAscent			:: !Int			// Distance between top    and base line
		,	fDescent		:: !Int			// Distance between bottom and base line
		,	fLeading		:: !Int			// Distance between two text lines
		,	fMaxWidth		:: !Int			// Max character width including spacing
		}
::	FontName	:==	String
::	FontStyle	:==	String
::	FontSize	:==	Int
::	Colour
	=	RGB RGBColour
	|	Black		| White
	|	DarkGrey	| Grey		| LightGrey	// 75%, 50%, and 25% Black
	|	Red			| Green		| Blue
	|	Cyan		| Magenta	| Yellow
::	RGBColour
	=	{	r	:: !Int						// The contribution of red
		,	g	:: !Int						// The contribution of green
		,	b	:: !Int						// The contribution of blue
		}

//	Colour constants:
BlackRGB				:==	{r=MinRGB,g=MinRGB,b=MinRGB}
WhiteRGB				:==	{r=MaxRGB,g=MaxRGB,b=MaxRGB}
MinRGB					:== 0
MaxRGB					:== 255

//	Font constants:
SerifFontDef			:==	{fName="Times",      fStyles=[],fSize=10}
SansSerifFontDef		:==	{fName="Arial",      fStyles=[],fSize=10}
SmallFontDef			:==	{fName="Small Fonts",fStyles=[],fSize=7 }
NonProportionalFontDef	:==	{fName="Courier",    fStyles=[],fSize=10}
SymbolFontDef			:==	{fName="Symbol",     fStyles=[],fSize=10}

//	Font style constants:
ItalicsStyle			:== "Italic"
BoldStyle				:== "Bold"
UnderlinedStyle			:== "Underline"


//	Standard lineheight of a font is the sum of its leading, ascent and descent:
fontLineHeight fMetrics	:==	fMetrics.fLeading + fMetrics.fAscent + fMetrics.fDescent

//	Useful when working with Ovals and Curves:
PI						:== 3.1415926535898
